from django.contrib import admin
from django.urls import path, include
from django.conf import settings
from django.conf.urls.static import static

urlpatterns = [
    path("admin/", admin.site.urls),
    path("", include("core.urls", namespace="core")),
    path("products/", include("products.urls", namespace="products")),  # 👈 ESTA LÍNEA ES FUNDAMENTAL
    path("cart/", include("cart.urls", namespace="cart")),  # 👈 carrito
]

if settings.DEBUG:
    urlpatterns += static(settings.MEDIA_URL, document_root=settings.MEDIA_ROOT)
